/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.services.xml.XmlWriterException;
import org.apache.maven.api.services.xml.XmlWriterRequest;
import org.apache.maven.impl.StaxLocation;
import org.apache.maven.impl.Utils;
import org.apache.maven.model.v4.MavenStaxReader;
import org.apache.maven.model.v4.MavenStaxWriter;

@Named
@Singleton
public class DefaultModelXmlFactory
implements ModelXmlFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Model read(@Nonnull XmlReaderRequest request) throws XmlReaderException {
        Utils.nonNull(request, "request");
        Path path = request.getPath();
        URL url = request.getURL();
        Reader reader = request.getReader();
        InputStream inputStream = request.getInputStream();
        if (path == null && url == null && reader == null && inputStream == null) {
            throw new IllegalArgumentException("path, url, reader or inputStream must be non null");
        }
        try {
            InputSource source = null;
            if (request.getModelId() != null || request.getLocation() != null) {
                source = new InputSource(request.getModelId(), path != null ? path.toUri().toString() : null);
            }
            MavenStaxReader xml = new MavenStaxReader();
            xml.setAddDefaultEntities(request.isAddDefaultEntities());
            if (inputStream != null) {
                return xml.read(inputStream, request.isStrict(), source);
            }
            if (reader != null) {
                return xml.read(reader, request.isStrict(), source);
            }
            if (path != null) {
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    Model model = xml.read(is, request.isStrict(), source);
                    return model;
                }
            }
            try (InputStream is = url.openStream();){
                Model model = xml.read(is, request.isStrict(), source);
                return model;
            }
        }
        catch (Exception e) {
            throw new XmlReaderException("Unable to read model: " + StaxLocation.getMessage(e), StaxLocation.getLocation(e), e);
        }
    }

    public void write(XmlWriterRequest<Model> request) throws XmlWriterException {
        block12: {
            Utils.nonNull(request, "request");
            Model content = Utils.nonNull((Model)request.getContent(), "content");
            Path path = request.getPath();
            OutputStream outputStream = request.getOutputStream();
            Writer writer = request.getWriter();
            Function inputLocationFormatter = request.getInputLocationFormatter();
            if (writer == null && outputStream == null && path == null) {
                throw new IllegalArgumentException("writer, outputStream or path must be non null");
            }
            try {
                MavenStaxWriter w = new MavenStaxWriter();
                if (inputLocationFormatter != null) {
                    w.setStringFormatter(inputLocationFormatter);
                }
                if (writer != null) {
                    w.write(writer, content);
                    break block12;
                }
                if (outputStream != null) {
                    w.write(outputStream, content);
                    break block12;
                }
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    w.write(os, content);
                }
            }
            catch (Exception e) {
                throw new XmlWriterException("Unable to write model: " + StaxLocation.getMessage(e), StaxLocation.getLocation(e), e);
            }
        }
    }

    public static Model fromXml(@Nonnull String xml) throws XmlReaderException {
        return (Model)new DefaultModelXmlFactory().fromXmlString(xml);
    }

    public static String toXml(@Nonnull Model content) throws XmlWriterException {
        return new DefaultModelXmlFactory().toXmlString(content);
    }
}

