/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscDirectDoublesTest {
    static final String LS = System.getProperty("line.separator");
    private static final boolean enablePrinting = false;

    @Test
    public void checkBounds() {
        KllDoublesSketch kll = KllMiscDirectDoublesTest.getDirectDoublesSketch(200, 1000);
        for (int i = 0; i < 1000; ++i) {
            kll.update((double)i);
        }
        double eps = kll.getNormalizedRankError(false);
        double est = kll.getQuantile(0.5);
        double ub = kll.getQuantileUpperBound(0.5);
        double lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)kll.getQuantile(0.5 - eps));
        KllMiscDirectDoublesTest.println("Ext     : " + est);
        KllMiscDirectDoublesTest.println("UB      : " + ub);
        KllMiscDirectDoublesTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    public void visualCheckToString() {
        int k = 20;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 0; i < 10; ++i) {
            sk.update((double)(i + 1));
        }
        KllMiscDirectDoublesTest.println(sk.toString(true, true));
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 0; i < 400; ++i) {
            sk2.update((double)(i + 1));
        }
        KllMiscDirectDoublesTest.println("\n" + sk2.toString(true, true));
        sk2.merge((KllSketch)sk);
        String s2 = sk2.toString(true, true);
        KllMiscDirectDoublesTest.println(LS + s2);
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int u = 108;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 108; ++i) {
            sk.update((double)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDirectDoublesTest.println(sk.toString(true, true));
            sk.update((double)(++i));
            KllMiscDirectDoublesTest.println(sk.toString(true, true));
            Assert.assertEquals((double)sk.getDoubleItemsArray()[sk.levelsArr[0]], (double)i);
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int k = 20;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        KllMiscDirectDoublesTest.show(sk, 20);
        DoublesSketchSortedView sv = sk.getSortedView();
        DoublesSortedViewIterator itr = sv.iterator();
        KllMiscDirectDoublesTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            double v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscDirectDoublesTest.printf("%12.1f%12d\n", v, wt);
        }
    }

    private static void show(KllDoublesSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((double)(i + 1));
        }
        KllMiscDirectDoublesTest.println(sk.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDoubleHeap() {
        int k = 20;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        sk.update(1.0);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyCompactMemorySegment() {
        int k = 20;
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = sk2.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        KllDoublesSketch sk = KllDoublesSketch.heapify((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        compBytes = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllDoublesSketch.heapify((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        sk2.update(1.0);
        compBytes = sk2.toByteArray();
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllDoublesSketch.heapify((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyUpdatableMemorySegment() {
        int k = 20;
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(compBytes);
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        sk2.update(1.0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((MemorySegment)wseg);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringDoubleUpdatable() {
        int k = 20;
        KllMiscDirectDoublesTest.println("#### CASE: DOUBLE FULL UPDATABLE");
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(upBytes);
        String s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDirectDoublesTest.println(s);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((MemorySegment)wseg);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectDoublesTest.println("#### CASE: DOUBLE EMPTY UPDATABLE");
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDirectDoublesTest.println(s);
        sk2 = KllDoublesSketch.wrap((MemorySegment)wseg);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectDoublesTest.println("#### CASE: DOUBLE SINGLE UPDATABL");
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        sk.update(1.0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscDirectDoublesTest.println(s);
        sk2 = KllDoublesSketch.wrap((MemorySegment)wseg);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wseg = MemorySegment.ofArray(upBytes2);
        s = KllPreambleUtil.toString((MemorySegment)wseg, (KllSketch.SketchType)KllSketch.SketchType.KLL_DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 21;
        KllDoublesSketch sk1 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (i = 1; i <= 21; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= 21; ++i) {
            sk2.update((double)(i + 100));
        }
        KllMiscDirectDoublesTest.println(sk1.toString(true, true));
        KllMiscDirectDoublesTest.println(sk2.toString(true, true));
        sk1.merge((KllSketch)sk2);
        KllMiscDirectDoublesTest.println(sk1.toString(true, true));
        Assert.assertEquals((double)sk1.getMaxItem(), (double)121.0);
        Assert.assertEquals((double)sk1.getMinItem(), (double)1.0);
    }

    @Test
    public void checkSizes() {
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int size1 = sk.currentSerializedSizeBytes(true);
        Assert.assertEquals((int)size1, (int)byteArr1.length);
        byte[] byteArr2 = sk.toByteArray();
        int size2 = sk.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)size2, (int)byteArr2.length);
    }

    @Test
    public void checkNewInstance() {
        int k = 200;
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[6000]);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)200, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)10000.0);
    }

    @Test
    public void checkDifferentM() {
        int k = 20;
        int m = 4;
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[1000]);
        KllDirectDoublesSketch sk = KllDirectDoublesSketch.newDirectUpdatableInstance((int)20, (int)4, (MemorySegment)dstSeg, null);
        for (int i = 1; i <= 200; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)200.0);
    }

    private static KllDoublesSketch getDirectDoublesSketch(int k, int n) {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        return KllDoublesSketch.wrap((MemorySegment)wseg);
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscDirectDoublesTest.println(s);
        KllMiscDirectDoublesTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

