/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.filters.bloomfilter.BloomFilter;
import org.apache.datasketches.filters.bloomfilter.BloomFilterBuilder;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BloomFilterBuilderTest {
    @Test
    public void testSuggestHashesFromSizes() {
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumHashes((long)0L, (long)32768L));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumHashes((long)10000L, (long)-1L));
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((long)100L, (long)65536L), (int)455);
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((long)10000L, (long)4096L), (int)1);
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((long)1000000000L, (long)0x1FFFFFFFCL), (int)6);
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((long)1500000L, (long)0x1000000L), (int)8);
    }

    @Test
    public void testSuggestHashesFromProbability() {
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumHashes((double)-0.5));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumHashes((double)2.5));
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((double)0.333), (int)2);
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((double)0.01), (int)7);
        Assert.assertEquals((int)BloomFilterBuilder.suggestNumHashes((double)1.0E-12), (int)40);
    }

    @Test
    public void testCreateFromSize() {
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createBySize((long)1000L, (int)-1, (long)123L));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createBySize((long)1000L, (int)65536, (long)123L));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createBySize((long)0L, (int)3, (long)456L));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createBySize((long)(BloomFilter.MAX_SIZE_BITS + 1L), (int)3, (long)456L));
        BloomFilter bf = BloomFilterBuilder.createBySize((long)0x200000L, (int)3);
        Assert.assertEquals((long)bf.getCapacity(), (long)0x200000L);
        Assert.assertEquals((int)bf.getNumHashes(), (int)3);
        Assert.assertEquals((long)bf.getBitsUsed(), (long)0L);
    }

    @Test
    public void testCreateFromAccuracy() {
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createByAccuracy((long)-1L, (double)0.01));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createByAccuracy((long)0x10000000000L, (double)0.01));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createByAccuracy((long)20000L, (double)-0.5));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.createByAccuracy((long)20000L, (double)2.0));
        long numDistinct = 30000L;
        double fpp = 0.001;
        BloomFilter bf = BloomFilterBuilder.createByAccuracy((long)30000L, (double)0.001);
        Assert.assertEquals((long)bf.getCapacity(), (long)((long)Math.ceil((double)BloomFilterBuilder.suggestNumFilterBits((long)30000L, (double)0.001) / 64.0) * 64L));
        Assert.assertEquals((short)bf.getNumHashes(), (short)BloomFilterBuilder.suggestNumHashes((double)0.001));
    }

    @Test
    public void testInitializeFromSize() {
        long numBits = 50000L;
        int numHashes = 7;
        long numBytes = BloomFilterBuilder.getSerializedFilterSize((long)50000L);
        WritableMemory wmem = WritableMemory.allocate((int)((int)numBytes));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeBySize((long)-1L, (int)7, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeBySize((long)0x10000000000L, (int)7, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeBySize((long)50000L, (int)-3, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeBySize((long)50000L, (int)100000, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeBySize((long)50000L, (int)7, (WritableMemory)WritableMemory.allocate((int)32)));
        BloomFilter bf = BloomFilterBuilder.initializeBySize((long)50000L, (int)7, (WritableMemory)wmem);
        Assert.assertEquals((long)bf.getCapacity(), (long)((long)Math.ceil(781.25) * 64L));
        Assert.assertEquals((short)bf.getNumHashes(), (short)7);
    }

    @Test
    public void testInitializeFromAccuracy() {
        long numDistinct = 30000L;
        double fpp = 0.001;
        long numBytes = BloomFilterBuilder.getSerializedFilterSizeByAccuracy((long)30000L, (double)0.001);
        WritableMemory wmem = WritableMemory.allocate((int)((int)numBytes));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeByAccuracy((long)-1L, (double)0.001, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeByAccuracy((long)0x10000000000L, (double)0.001, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeByAccuracy((long)30000L, (double)-0.5, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeByAccuracy((long)30000L, (double)2.0, (WritableMemory)wmem));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.initializeByAccuracy((long)30000L, (double)0.001, (WritableMemory)WritableMemory.allocate((int)32)));
        BloomFilter bf = BloomFilterBuilder.initializeByAccuracy((long)30000L, (double)0.001, (WritableMemory)wmem);
        Assert.assertEquals((long)bf.getCapacity(), (long)((long)Math.ceil((double)BloomFilterBuilder.suggestNumFilterBits((long)30000L, (double)0.001) / 64.0) * 64L));
        Assert.assertEquals((short)bf.getNumHashes(), (short)BloomFilterBuilder.suggestNumHashes((double)0.001));
    }

    @Test
    public void testSuggestNumFilterBits() {
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumFilterBits((long)0L, (double)0.01));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumFilterBits((long)2500L, (double)0.0));
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilterBuilder.suggestNumFilterBits((long)1000L, (double)2.5));
        Assert.assertEquals((long)BloomFilterBuilder.suggestNumFilterBits((long)250000L, (double)0.01), (long)2396265L);
        BloomFilter bf = BloomFilterBuilder.createByAccuracy((long)250000L, (double)0.01);
        Assert.assertEquals((long)bf.getCapacity(), (long)2396288L);
        Assert.assertEquals((short)bf.getNumHashes(), (short)BloomFilterBuilder.suggestNumHashes((long)250000L, (long)2396288L));
        Assert.assertEquals((long)BloomFilterBuilder.suggestNumFilterBits((long)5000000L, (double)1.0E-4), (long)95850584L);
        long seed = 19805243L;
        bf = BloomFilterBuilder.createByAccuracy((long)5000000L, (double)1.0E-4, (long)19805243L);
        Assert.assertEquals((long)bf.getCapacity(), (long)95850624L);
        Assert.assertEquals((short)bf.getNumHashes(), (short)BloomFilterBuilder.suggestNumHashes((long)5000000L, (long)95850624L));
        Assert.assertEquals((long)bf.getSeed(), (long)19805243L);
    }
}

