/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.query.EmbeddableResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;

class EmbeddableRowReader
implements RowReader<DataRow> {
    private final int startIndex;
    private final int mapCapacity;
    private final ExtendedType[] converters;
    private final String[] labels;
    private final int[] types;

    EmbeddableRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, EmbeddableResultSegment segment) {
        int segmentWidth = segment.getFields().size();
        this.startIndex = segment.getColumnOffset();
        this.converters = new ExtendedType[segmentWidth];
        this.types = new int[segmentWidth];
        this.labels = new String[segmentWidth];
        ExtendedType[] converters = descriptor.getConverters();
        ColumnDescriptor[] columns = descriptor.getColumns();
        for (int i = 0; i < segmentWidth; ++i) {
            this.converters[i] = converters[this.startIndex + i];
            this.types[i] = columns[this.startIndex + i].getJdbcType();
            this.labels[i] = segment.getFields().get(columns[this.startIndex + i].getName());
        }
        this.mapCapacity = (int)Math.ceil((double)segmentWidth / 0.75);
    }

    @Override
    public DataRow readRow(ResultSet resultSet) {
        try {
            DataRow row = new DataRow(this.mapCapacity);
            int len = this.converters.length;
            for (int i = 0; i < len; ++i) {
                Object val = this.converters[i].materializeObject(resultSet, this.startIndex + i + 1, this.types[i]);
                row.put(this.labels[i], val);
            }
            return row;
        }
        catch (CayenneRuntimeException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneRuntimeException("Exception materializing column.", Util.unwindException(otherex), new Object[0]);
        }
    }
}

