/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.xop;

import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;

public abstract class AbstractXOPEncodingFilterHandler
extends XmlHandlerWrapper {
    private boolean inXOPInclude;

    public AbstractXOPEncodingFilterHandler(XmlHandler parent) {
        super(parent);
    }

    protected abstract String processCharacterData(Object var1) throws StreamException;

    private static String getURLForContentID(String contentID) {
        return "cid:" + contentID.replaceAll("%", "%25");
    }

    private boolean flushIfNecessary() throws StreamException {
        if (this.inXOPInclude) {
            super.endElement();
            this.inXOPInclude = false;
            return false;
        }
        return true;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        this.flushIfNecessary();
        super.startElement(namespaceURI, localName, prefix);
    }

    @Override
    public void endElement() throws StreamException {
        this.flushIfNecessary();
        super.endElement();
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        String contentID;
        if (!ignorable && (contentID = this.processCharacterData(data)) != null) {
            super.startElement("http://www.w3.org/2004/08/xop/include", "Include", "xop");
            super.processNamespaceDeclaration("xop", "http://www.w3.org/2004/08/xop/include");
            super.processAttribute("", "href", "", AbstractXOPEncodingFilterHandler.getURLForContentID(contentID), "CDATA", true);
            super.attributesCompleted();
            this.inXOPInclude = true;
            return;
        }
        super.processCharacterData(data, ignorable);
    }

    @Override
    public void completed() throws StreamException {
        super.completed();
    }

    @Override
    public boolean drain() throws StreamException {
        if (super.drain()) {
            return this.flushIfNecessary();
        }
        return false;
    }
}

